/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.servlet.util;

import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerQueue;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.ui.bonsai.BonsaiUIStyle;
import java.util.Iterator;

public class UIRefreshManager {
    public static final int SETTINGS_CHANGED_REFRESH_TYPE = 0;
    public static final int TREE_CHANGED_REFRESH_TYPE = 1;
    public static final int TREE_SELECTION_CHANGED_REFRESH_TYPE = 2;
    public static final String REFRESH_TYPE_PARAM_NAME = "refresh_type";

    private UIRefreshManager() {
    }

    public static void refresh(int type, HMCSession hmcSession) {
        String refreshTypeParam = "refresh_type=" + type;
        switch (type) {
            case 0: {
                UIRefreshManager.refreshFrame(null, "init.do", refreshTypeParam, hmcSession);
                break;
            }
            case 1: {
                UIRefreshManager.refreshFrame("frames['navigation_frame']", "navigation.do", refreshTypeParam, hmcSession);
                UIRefreshManager.refreshFrame("frames['workarea_frame']", "workarea.do", refreshTypeParam, hmcSession);
                UIRefreshManager.refreshFrame("frames['health_frame']", "health.do", refreshTypeParam, hmcSession);
                break;
            }
            case 2: {
                UIRefreshManager.refreshFrame("frames['workarea_frame']", "workarea.do", refreshTypeParam, hmcSession);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type of refresh requested!");
            }
        }
    }

    public static void refresh(int type) {
        Iterator i = BonsaiUIStyle.getAllHMCSessions().iterator();
        while (i.hasNext()) {
            UIRefreshManager.refresh(type, (HMCSession)i.next());
        }
    }

    public static void refreshFrame(String frame, String newLocation, String requestParms, HMCSession hmcSession) {
        requestParms = requestParms != null ? "?" + requestParms : "";
        if (frame == null) {
            frame = "";
        }
        if (frame.length() > 0 && !frame.startsWith(".")) {
            frame = "." + frame;
        }
        TaskControllerQueue queue = TaskControllerQueue.getTaskControllerQueue(hmcSession);
        queue.sendScript("top.window.frames['hmcmainui']" + frame + ".location.href='" + "/hmc/ui/bonsai/" + newLocation + requestParms + "';");
    }

    public static void reloadFrame(String frame, HMCSession hmcSession) {
        if (frame == null) {
            frame = "";
        }
        if (frame.length() > 0 && !frame.startsWith(".")) {
            frame = "." + frame;
        }
        TaskControllerQueue queue = TaskControllerQueue.getTaskControllerQueue(hmcSession);
        queue.sendScript("top.window.frames['hmcmainui']" + frame + ".document.location.reload();");
    }

    public static void refreshFrame(String frame, String newLocation, String requestParms) {
        Iterator i = BonsaiUIStyle.getAllHMCSessions().iterator();
        while (i.hasNext()) {
            UIRefreshManager.refreshFrame(frame, newLocation, requestParms, (HMCSession)i.next());
        }
    }
}

